-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)  
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p1 = Citadels.GetPlayer(1)
    self.attackPoint = Game:GetEntity("fortSquare"):GetPosition()
    
    if not self.loaded then
      self.gDestroy = false
      self.active = true
      self.triggered = false
      self.limit = 120
      self.timer = self.limit
    end
    
    self.fortAttack:LinkToTarget("foAtt")
  end
  
  if self.active  then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      self.fortAttack:TriggerAllTargets()
      self.limit = self.limit * 1.5
      self.timer = self.limit
      self.active = false
    end    
  end  
  
  if self.gDestroy and not self.triggered then
    ShiftAttack(self)
    self.gDestroy = false
    self.triggered = true
  end
end

function ShiftAttack(self)
  self.p1:Deselect()
  self.p1:SelectUnitsByName("foAtt_".."*")
  self.p1:SetAggressive()
  self.p1:Move(self.attackPoint)
end

function OnTrigger(self, source, target)
  if target == "gateDestroyed" then
    self.gDestroy = true
  elseif target == "deactivate" then
    self.active = false
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.gDestroy = ar:Read()
    self.active = ar:Read()
    self.triggered = ar:Read()
    self.limit = ar:Read()
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.gDestroy)
    ar:Write(self.active)
    ar:Write(self.triggered)
    ar:Write(self.limit)
    ar:Write(self.timer)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("gateDestroyed")
  self:AddTriggerTarget("deactivateFoAtt")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("fortAttack")
end
